package ru.yandex.direct.core.entity.retargeting.service;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.retargeting.container.RetargetingSelection;
import ru.yandex.direct.core.entity.retargeting.model.AdGroupContainsRetargetings;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между условиями нацеливания на аудиторию и группами объявлений
 */
@ParametersAreNonnullByDefault
@Service
public class AdGroupWithRetargetingsService implements RelationshipService<AdGroupContainsRetargetings, Long, Long> {
    private final ShardHelper shardHelper;
    private final RetargetingRepository retargetingRepository;
    private final AdGroupService adGroupService;

    @Autowired
    public AdGroupWithRetargetingsService(ShardHelper shardHelper,
                                          RetargetingRepository retargetingRepository,
                                          AdGroupService adGroupService) {
        this.shardHelper = shardHelper;
        this.retargetingRepository = retargetingRepository;
        this.adGroupService = adGroupService;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        var adGroupTypes = adGroupService.getAdGroupTypes(clientId, adGroupIds).values();
        //для групп внутренней рекламы копирование в RetargetingConditionInternalService
        if (adGroupTypes.contains(AdGroupType.INTERNAL)) {
            return Collections.emptySet();
        }

        var shard = shardHelper.getShardByClientIdStrictly(clientId);
        var retIdMap = retargetingRepository.getRetIdWithCidWithoutLimit(shard,
                new RetargetingSelection().withAdGroupIds(List.copyOf(adGroupIds)),
                List.of());
        return retIdMap.keySet();
    }
}
