package ru.yandex.direct.core.entity.retargeting.service;

import java.util.Collections;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.retargeting.model.InternalAdGroupContainsRetargetings;
import ru.yandex.direct.dbutil.model.ClientId;

@Service
@ParametersAreNonnullByDefault
public class InternalAdGroupWithRetargetingsService implements RelationshipService<InternalAdGroupContainsRetargetings, Long, Long> {

    private final AdGroupService adGroupService;

    @Autowired
    public InternalAdGroupWithRetargetingsService(AdGroupService adGroupService) {
        this.adGroupService = adGroupService;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        var adGroupTypes = adGroupService.getAdGroupTypes(clientId, adGroupIds).values();
        //для групп внутренней рекламы не работает RetargetingConditionService
        if (adGroupTypes.contains(AdGroupType.INTERNAL)) {
            return adGroupIds;
        }
        return Collections.emptySet();
    }
}
