package ru.yandex.direct.core.entity.retargeting.service;

import java.util.function.Function;

import ru.yandex.direct.core.entity.bids.container.BidSelectionCriteria;

public enum RequestSetBidType {
    UNKNOWN(bid -> null),
    ID(BidSelectionCriteria::getId),
    ADGROUP_ID(BidSelectionCriteria::getAdGroupId),
    CAMPAIGN_ID(BidSelectionCriteria::getCampaignId);

    private final Function<BidSelectionCriteria, Long> bidCriteriaSupplier;

    RequestSetBidType(Function<BidSelectionCriteria, Long> bidCriteriaSupplier) {
        this.bidCriteriaSupplier = bidCriteriaSupplier;
    }

    public Function<BidSelectionCriteria, Long> getBidCriteriaSupplier() {
        return bidCriteriaSupplier;
    }

    public static RequestSetBidType getByBidSelectionCriteria(BidSelectionCriteria bidSelectionCriteria) {
        if (bidSelectionCriteria.getId() != null) {
            return ID;
        } else if (bidSelectionCriteria.getAdGroupId() != null) {
            return ADGROUP_ID;
        } else if (bidSelectionCriteria.getCampaignId() != null) {
            return CAMPAIGN_ID;
        } else {
            return UNKNOWN;
        }
    }
}
