package ru.yandex.direct.core.entity.retargeting.service;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.retargeting.container.RetargetingSelection;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionConnectedByRetargeting;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между Retargeting Condition и Retargeting, позволяет получить по Retargeting Condition связанные с ними
 * Retargeting
 */
@ParametersAreNonnullByDefault
@Service
public class RetargetingOfRetargetingConditionService
        implements RelationshipService<RetargetingConditionConnectedByRetargeting, Long, Long> {
    private final RetargetingRepository repository;
    private final ShardHelper shardHelper;

    @Autowired
    public RetargetingOfRetargetingConditionService(ShardHelper shardHelper, RetargetingRepository repository) {
        this.repository = repository;
        this.shardHelper = shardHelper;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> retCondIds) {
        var shard = shardHelper.getShardByClientIdStrictly(clientId);
        var retIdToCidMap = repository.getRetIdWithCidWithoutLimit(shard,
                new RetargetingSelection().withRetargetingListIds(List.copyOf(retCondIds)),
                List.of());
        return retIdToCidMap.keySet();
    }
}
