package ru.yandex.direct.core.entity.retargeting.service;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.operation.Applicability;

@ParametersAreNonnullByDefault
public class UpdateRetargetingConditionsConfig {
    private Applicability applicability;
    private boolean validationOnly;
    private boolean skipPixelValidation;

    public UpdateRetargetingConditionsConfig(Applicability applicability) {
        this.applicability = applicability;
        validationOnly = false;
        skipPixelValidation = false;
    }

    public UpdateRetargetingConditionsConfig setValidationOnly(boolean applyValidationOnly) {
        this.validationOnly = applyValidationOnly;
        return this;
    }

    boolean getValidationOnly() {
        return validationOnly;
    }

    public Applicability getApplicability() {
        return applicability;
    }

    boolean isSkipPixelValidation() {
        return skipPixelValidation;
    }

    public UpdateRetargetingConditionsConfig skipPixelValidation() {
        this.skipPixelValidation = true;
        return this;
    }
}
