package ru.yandex.direct.core.entity.retargeting.service.helper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithPixels;
import ru.yandex.direct.core.entity.banner.service.BannerService;
import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Класс, позволяющий собрать необходимую для валидации условий ретаргетинга информацию по баннерам,
 * права на пиксели аудита которых зависят от валидируемых условий ретаргетинга
 */
@Component
@ParametersAreNonnullByDefault
public class RetargetingConditionBannerWithPixelsValidationHelper {

    private final BannerService bannerService;

    @Autowired
    public RetargetingConditionBannerWithPixelsValidationHelper(BannerService bannerService) {
        this.bannerService = bannerService;
    }

    /**
     * Получения списка баннеров с пикселями, привязанных к группам объявлений, имеющих данные условия ретаргетинга
     *
     * @param shard                       номер шарда
     * @param adGroupIdsByRetConditionIds соответствие идентификаторов адгрупп идентификаторам условий ретаргетинга
     */
    public Map<Long, List<BannerWithPixels>> getBannersWithPixelsByRetargetingConditionIds(int shard,
                                                                                           ClientId clientId,
                                                                                           Map<Long, List<Long>> adGroupIdsByRetConditionIds,
                                                                                           Collection<Long> adGroupIds) {
        Map<Long, List<BannerWithPixels>> bannersByAdGroups =
                bannerService.getBannersWithPixelsByAdGroups(shard, clientId, adGroupIds);
        return EntryStream.of(adGroupIdsByRetConditionIds)
                .mapValues(t -> StreamEx.of(t)
                        .map(bannersByAdGroups::get)
                        .filter(Objects::nonNull)
                        .toFlatList(s -> s))
                .toMap();
    }
}
