package ru.yandex.direct.core.entity.retargeting.service.validation2;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.unique;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notInSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Service
@ParametersAreNonnullByDefault
public class DeleteRetargetingConditionValidationService2 {

    @Autowired
    RetargetingConditionRepository retConditionRepository;

    @Autowired
    ShardHelper shardHelper;

    public ValidationResult<List<Long>, Defect> validate(List<Long> ids, ClientId clientId) {
        return ListValidationBuilder.<Long, Defect>of(ids)
                .checkBy(elements -> validateElements(elements, clientId), When.isValid())
                .getResult();
    }

    private ValidationResult<List<Long>, Defect> validateElements(List<Long> ids, ClientId clientId) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        Set<Long> existingIds = new HashSet<>(retConditionRepository.getExistingIds(shard, clientId, ids));
        Set<Long> usedIds = new HashSet<>(retConditionRepository.getUsedRetargetingConditionsIds(shard, existingIds));

        return ListValidationBuilder.<Long, Defect>of(ids)
                .checkEach(notNull())
                .checkEach(validId())
                .checkEach(unique(), RetargetingDefects.duplicatedRetargetingConditionId())
                .checkEach(inSet(existingIds), CommonDefects.objectNotFound(), When.isValid())
                .checkEach(notInSet(usedIds), CommonDefects.unableToDelete(), When.isValid())
                .getResult();
    }
}
