package ru.yandex.direct.core.entity.retargeting.service.validation2;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.retargeting.container.RetargetingConditionValidationData;

import static java.util.Collections.emptySet;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

public class ExistingRetargetingConditionsInfo {
    private final int existingCount;
    private final Set<String> existingNames;
    private final Set<String> existingRules;

    public ExistingRetargetingConditionsInfo(int existingCount, Set<String> existingNames, Set<String> existingRules) {
        this.existingCount = existingCount;
        this.existingNames = existingNames;
        this.existingRules = existingRules;
    }

    public ExistingRetargetingConditionsInfo(int existingCount) {
        this(existingCount, emptySet(), emptySet());
    }

    public static ExistingRetargetingConditionsInfo fromRetargetingConditionsValidationData(
            List<RetargetingConditionValidationData> validationData) {
        Set<String> existingNames = listToSet(validationData, RetargetingConditionValidationData::getName);
        Set<String> existingRules = listToSet(validationData, RetargetingConditionValidationData::getRulesJson);
        return new ExistingRetargetingConditionsInfo(validationData.size(), existingNames, existingRules);
    }

    public int getExistingCount() {
        return existingCount;
    }

    public Set<String> getExistingNames() {
        return existingNames;
    }

    public Set<String> getExistingRules() {
        return existingRules;
    }
}
