package ru.yandex.direct.core.entity.retargeting.service.validation2;

import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.retargeting.container.ReplaceRetargetingConditionGoal;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.retargeting.Constants.MAX_RETARGETINGS_PER_REQUEST;
import static ru.yandex.direct.core.entity.retargeting.Constants.MIN_RETARGETINGS_PER_REQUEST;
import static ru.yandex.direct.core.entity.retargeting.container.ReplaceRetargetingConditionGoal.NEW_GOAL_ID;
import static ru.yandex.direct.core.entity.retargeting.container.ReplaceRetargetingConditionGoal.OLD_GOAL_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.constraint.GoalExistenceConstraint2.goalExists;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.minListSize;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.unique;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Service
public class ReplaceGoalsInRetargetingValidationService2 {
    public ValidationResult<List<ReplaceRetargetingConditionGoal>, Defect> validate(
            List<ReplaceRetargetingConditionGoal> replaceRetargetingConditionGoals,
            Set<Long> goalIds,
            boolean skipGoalExistenceCheck
    ) {
        ListValidationBuilder<ReplaceRetargetingConditionGoal, Defect> validationBuilder =
                ListValidationBuilder.of(replaceRetargetingConditionGoals);

        validationBuilder
                .check(notNull())
                .check(minListSize(MIN_RETARGETINGS_PER_REQUEST))
                .check(maxListSize(MAX_RETARGETINGS_PER_REQUEST))
                .checkEach(unique(ReplaceRetargetingConditionGoal::getOldGoalId))
                .checkEachBy(x -> validateReplaceRetargetingConditionGoal(x, goalIds, skipGoalExistenceCheck));

        return validationBuilder.getResult();
    }

    private ValidationResult<ReplaceRetargetingConditionGoal, Defect> validateReplaceRetargetingConditionGoal(
            ReplaceRetargetingConditionGoal retargetingConditionGoal,
            Set<Long> goals,
            boolean skipGoalExistenceCheck
    ) {
        ModelItemValidationBuilder<ReplaceRetargetingConditionGoal> vb =
                ModelItemValidationBuilder.of(retargetingConditionGoal);
        vb.item(NEW_GOAL_ID)
                .check(notNull())
                .check(validId());
        if (!vb.getResult().hasAnyErrors()) {
            vb.item(NEW_GOAL_ID).check(goalExists(goals), When.isValidAnd(When.isFalse(skipGoalExistenceCheck)));
        }
        vb.item(OLD_GOAL_ID)
                .check(notNull())
                .check(validId());

        return vb.getResult();
    }
}
