package ru.yandex.direct.core.entity.retargeting.service.validation2;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.crypta.repository.CryptaSegmentRepository;
import ru.yandex.direct.core.entity.crypta.service.CryptaSuggestService;
import ru.yandex.direct.core.entity.retargeting.model.CryptaGoalScope;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.GoalType;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;

@Service
@ParametersAreNonnullByDefault
public class RetargetingConditionCryptaSegmentsProvider {
    private final CryptaSegmentRepository cryptaSegmentRepository;
    private final CryptaSuggestService cryptaSuggestService;

    @Autowired
    public RetargetingConditionCryptaSegmentsProvider(CryptaSegmentRepository cryptaSegmentRepository,
                                                      CryptaSuggestService cryptaSuggestService) {
        this.cryptaSegmentRepository = cryptaSegmentRepository;
        this.cryptaSuggestService = cryptaSuggestService;
    }

    /**
     * Выдаёт сегменты крипты (в виде целей), которые могут быть использованы для клиента
     */
    public Map<Long, Goal> getAllowedCryptaSegments(boolean isInternalAdProduct,
                                                    boolean isNewCustomAudienceEnabled,
                                                    List<RetargetingCondition> retConditionList) {

        var cryptaGoals = new HashMap<Long, Goal>();
        Set<CryptaGoalScope> scopes = new HashSet<>();
        if (isInternalAdProduct) {
            scopes.add(CryptaGoalScope.INTERNAL_AD);
        } else {
            scopes.add(CryptaGoalScope.COMMON);
            if (isNewCustomAudienceEnabled) {
                // пока под фичей поддерживаем только тго,
                // но у клиента может быть включена фича и он заводит медийку или редактирует старую группу
                // поэтому не удаляем предыдущие данные
                scopes.add(CryptaGoalScope.PERFORMANCE);
                cryptaGoals.putAll(retrieveHostsForConditions(retConditionList));
            }
        }

        cryptaGoals.putAll(cryptaSegmentRepository.getAll(scopes));

        return cryptaGoals;
    }

    private Map<Long, Goal> retrieveHostsForConditions(List<RetargetingCondition> retConditionList) {
        var inputHostIds = StreamEx.of(retConditionList)
                .map(RetargetingCondition::collectGoalsSafe)
                .flatMap(Collection::stream)
                .filter(goal -> goal.getType() == GoalType.HOST)
                .map(Goal::getId)
                .toList();

        return cryptaSuggestService.getGoalsByHostIds(inputHostIds);
    }

}
