package ru.yandex.direct.core.entity.retargeting.service.validation2;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.campaign.model.CampaignExperiment;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.metrika.client.MetrikaClient;
import ru.yandex.direct.metrika.client.model.request.GoalType;
import ru.yandex.direct.metrika.client.model.response.RetargetingCondition;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.metrika.client.model.response.RetargetingCondition.Type.AB_SEGMENT;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Service
public class RetargetingConditionExperimentsValidationService {

    private final MetrikaClient metrikaClient;
    private final RbacService rbacService;

    @Autowired
    public RetargetingConditionExperimentsValidationService(MetrikaClient metrikaClient, RbacService rbacService) {
        this.metrikaClient = metrikaClient;
        this.rbacService = rbacService;
    }

    @Deprecated
    public ValidationResult<List<CampaignExperiment>, Defect> validateRetargetingConditionsForExperiments(
            ClientId clientId, List<CampaignExperiment> campaignExperiments) {

        var uids = rbacService.getClientRepresentativesUids(clientId);
        Map<Long, List<RetargetingCondition>> goalsByUids = metrikaClient.getGoals(uids, GoalType.AB_SEGMENT)
                .getUidToConditions();

        List<ru.yandex.direct.metrika.client.model.response.RetargetingCondition> clientAbSegments =
                getClientAbSegments(goalsByUids);

        Map<Long, List<Long>> clientAbSegmentIdsBySectionId = StreamEx.of(clientAbSegments)
                .mapToEntry(ru.yandex.direct.metrika.client.model.response.RetargetingCondition::getSectionId,
                        ru.yandex.direct.metrika.client.model.response.RetargetingCondition::getId)
                .filterKeys(Objects::nonNull)
                .grouping();

        Set<Long> clientAbSegmentIds = listToSet(clientAbSegments,
                ru.yandex.direct.metrika.client.model.response.RetargetingCondition::getId);

        return ItemValidationBuilder.<List<CampaignExperiment>, Defect>of(campaignExperiments)
                .checkBy(experiments -> ExperimentContainerValidator
                        .build(clientAbSegmentIdsBySectionId.keySet(), clientAbSegmentIds).apply(experiments))
                .getResult();
    }

    private List<ru.yandex.direct.metrika.client.model.response.RetargetingCondition> getClientAbSegments(Map<Long,
            List<ru.yandex.direct.metrika.client.model.response.RetargetingCondition>> goalsByUids) {
        return EntryStream.of(goalsByUids)
                .values()
                .flatMap(Collection::stream)
                .filter(x -> x.getType() == AB_SEGMENT)
                .toList();
    }

    private static class ExperimentContainerValidator implements Validator<List<CampaignExperiment>,
            Defect> {
        private final Set<Long> clientSectionIds;
        private final Set<Long> clientAbSegmentIds;

        private ExperimentContainerValidator(Set<Long> clientSectionIds, Set<Long> clientAbSegmentIds) {
            this.clientSectionIds = clientSectionIds;
            this.clientAbSegmentIds = clientAbSegmentIds;
        }

        private static ExperimentContainerValidator build(Set<Long> clientSectionIds, Set<Long> clientAbSegmentIds) {
            return new ExperimentContainerValidator(clientSectionIds, clientAbSegmentIds);
        }

        @Override
        public ValidationResult<List<CampaignExperiment>, Defect> apply(
                List<CampaignExperiment> input) {

            ListValidationBuilder<CampaignExperiment, Defect> lvb = ListValidationBuilder.of(input);

            return lvb
                    .checkEachBy(ExperimentValidator.build(clientSectionIds, clientAbSegmentIds))
                    .getResult();
        }
    }

    private static class ExperimentValidator implements Validator<CampaignExperiment,
            Defect> {
        private final Set<Long> clientSectionIds;
        private final Set<Long> clientAbSegmentIds;

        private ExperimentValidator(Set<Long> clientSectionIds, Set<Long> clientAbSegmentIds) {
            this.clientSectionIds = clientSectionIds;
            this.clientAbSegmentIds = clientAbSegmentIds;
        }

        private static ExperimentValidator build(Set<Long> clientSectionIds, Set<Long> clientAbSegmentIds) {
            return new ExperimentValidator(clientSectionIds, clientAbSegmentIds);
        }

        @Override
        public ValidationResult<CampaignExperiment, Defect> apply(
                CampaignExperiment input) {

            ModelItemValidationBuilder<CampaignExperiment> vb =
                    ModelItemValidationBuilder.of(input);

            vb.list(CampaignExperiment.SECTION_IDS)
                    .checkEach(inSet(clientSectionIds));
            vb.list(CampaignExperiment.AB_SEGMENT_GOAL_IDS)
                    .checkEach(inSet(clientAbSegmentIds));

            return vb.getResult();
        }
    }
}
