package ru.yandex.direct.core.entity.retargeting.service.validation2;

import ru.yandex.direct.core.validation.defects.params.FieldRequirementsDefectParams;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class RetargetingDefectIds {

    public enum Gen implements DefectId<Void> {
        MAX_IDS_IN_SELECTION,
        LIMIT_MUST_BE_GREATER_THAN_ZERO,

        OFFSET_MUST_BE_POSITIVE,
        NO_NEEDED_PARAMS_IN_SELECTION,
        REQUIRED_TIME_FOR_GOAL_OR_SEGMENT,
        INVALID_USE_OF_FIELD_EXTRA_FIELD_FOR_GOAL_OR_SEGMENT,
        CANNOT_CHANGE_RETARGETING_SCOPE,
        INVALID_GOALS_FOR_TYPE,
        DUPLICATED_OBJECT_WITH_NAME,
        DUPLICATED_OBJECT_WITH_RULES,
        ABSENT_IDS_IN_SELECTION,
        NOT_FOUND,
        WARNING_NOT_SUSPENDED,
        WARNING_ALREADY_SUSPENDED,
        WARNING_DUPLICATED_RETARGETING_ID,
        AUDIENCE_NOT_FOUND,
        DUPLICATED_RETARGETING_ID,
        DUPLICATED_RETARGETING_CONDITION_ID,
        RETARGETING_CONDITION_ALREADY_EXISTS,
        RETARGETING_CONDITION_NOT_FOUND,
        INVALID_RETARGETING_CONDITION,
        INVALID_RETARGETING_CONDITION_BY_PRICE_PACKAGE,
        INCONSISTENT_RETARGETING_CONDITION_BY_DEFAULT_ADGROUP,
        INCONSISTENT_STATE_TARGETING_CATEGORY,
        NOT_ELIGABLE_ADGROUP,
        DUPLICATED_RETARGETING_CONDITION_ID_FOR_ADGROUP_ID,
        INTERESTS_TYPE_IS_NOT_SPECIFIED,
        CRYPTA_GOALS_ALLOWED_ONLY_FOR_INTERESTS_TYPE,
        ALL_GOALS_MUST_BE_EITHER_FROM_METRIKA_OR_CRYPTA,
        CRYPTA_GOALS_ALLOWED_ONLY_FOR_OR_CONDITION,
        ALL_CRYPTA_GOALS_MUST_HAVE_SAME_TYPE,
        ALL_SOCIAL_DEMO_GOALS_MUST_HAVE_SAME_PARENT_ID,
        MUST_NOT_CONTAIN_ALL_ELEMENTS,
        UNSUPPORTED_GOAL_ID,
        MUST_CONTAIN_POSITIVE_ELEMENT,
        NO_RIGHTS_IN_ARCHIVED_ADGROUP,
        AUDIENCE_TARGET_ALLOWED_IN_MOBILE_CONTENT_CAMPAIGN,
        INTEREST_LIMIT_EXCEEDED,
        CPM_YNDX_FRONTPAGE_RETARGETINGS_NOT_ALLOWED,
        INVALID_RETARGETING_CONDITION_IN_USER_PROFILE_FOR_TGO,
        DUPLICATED_GOAL
    }

    public enum Nums implements DefectId<NumberDefectParams> {
        MAX_SIZE_IN_ADGROUP,
        MAX_SIZE_IN_CPM_ADGROUP,
        MAX_SIZE_USER_PROFILE_IN_CPM_ADGROUP,
        LIMIT_MUST_BE_LESS_THAN_VALUE
    }

    public enum IdParametrized implements DefectId<ModelIdDefectParams> {
        CAMPAIGN_STATUS_ARCHIVED_ON_ADD,
        CAMPAIGN_STATUS_ARCHIVED_ON_DELETE,
        CAMPAIGN_STATUS_ARCHIVED_ON_SUSPEND,
        ADGROUP_NOT_FOUND,
        CAMPAIGN_STATUS_ARCHIVED_ON_RESUME,
        RETARGETING_CONDITION_NOT_FOUND_WITH_ID,
    }

    public enum FieldRequirements implements DefectId<FieldRequirementsDefectParams> {
        MUTUALLY_EXCLUSIVE_PARAMETERS,
        LEAST_ONE_FIELD_REQUIRED
    }
}
