package ru.yandex.direct.core.entity.retargeting.service.validation2;


import ru.yandex.direct.core.entity.bids.container.SetBidItem;
import ru.yandex.direct.core.entity.bids.validation.BidsDefects;
import ru.yandex.direct.core.validation.defects.params.FieldRequirementsDefectParams;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.Path;

public class RetargetingDefects {

    public static Defect<Void> maxIdsInSelection() {
        return new Defect<>(RetargetingDefectIds.Gen.MAX_IDS_IN_SELECTION);
    }

    public static Defect requiredTimeForGoalOrSegment() {
        return new Defect<>(RetargetingDefectIds.Gen.REQUIRED_TIME_FOR_GOAL_OR_SEGMENT);
    }

    public static Defect invalidGoalsForType() {
        return new Defect<>(RetargetingDefectIds.Gen.INVALID_GOALS_FOR_TYPE);
    }

    public static Defect<Void> duplicatedObjectWithName() {
        return new Defect<>(RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_NAME);
    }

    public static Defect duplicatedObjectWithRules() {
        return new Defect<>(RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_RULES);
    }

    public static Defect duplicatedRetargetingId() {
        return new Defect<>(RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_ID);
    }

    public static Defect duplicatedRetargetingConditionId() {
        return new Defect<>(RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID);
    }

    public static Defect cannotChangeRetargetingScope() {
        return new Defect<>(RetargetingDefectIds.Gen.CANNOT_CHANGE_RETARGETING_SCOPE);
    }

    public static Defect badStatusCampaignArchivedOnAdd(Long campaignId) {
        return new Defect<>(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_ADD,
                new ModelIdDefectParams().withId(campaignId));
    }

    public static Defect badCampaignStatusArchivedOnSuspend(Long campaignId) {
        return new Defect<>(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_SUSPEND,
                new ModelIdDefectParams().withId(campaignId));
    }

    public static Defect badCampaignStatusArchivedOnResume(Long campaignId) {
        return new Defect<>(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_RESUME,
                new ModelIdDefectParams().withId(campaignId));
    }

    public static Defect cantRemoveAudienceTargetFromArchivedCampaign(Long campaignId) {
        return new Defect<>(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_DELETE,
                new ModelIdDefectParams().withId(campaignId));
    }

    public static Defect mutuallyExclusiveParameters(Path path1, Path path2) {
        return new Defect<>(RetargetingDefectIds.FieldRequirements.MUTUALLY_EXCLUSIVE_PARAMETERS,
                new FieldRequirementsDefectParams().withPath1(path1).withPath2(path2));
    }

    public static Defect requiredAtLeastOneOfFields(Path path1, Path path2) {
        return new Defect<>(RetargetingDefectIds.FieldRequirements.LEAST_ONE_FIELD_REQUIRED,
                new FieldRequirementsDefectParams().withPath1(path1).withPath2(path2));
    }

    public static Defect maxCollectionSizeAdGroup(Integer max) {
        return new Defect<>(RetargetingDefectIds.Nums.MAX_SIZE_IN_ADGROUP,
                new NumberDefectParams().withMax(max));
    }

    public static Defect maxCollectionSizeCpmAdGroup(Integer max) {
        return new Defect<>(RetargetingDefectIds.Nums.MAX_SIZE_IN_CPM_ADGROUP,
                new NumberDefectParams().withMax(max));
    }

    public static Defect maxCollectionSizeUserProfileInAdGroup() {
        return new Defect<>(RetargetingDefectIds.Nums.MAX_SIZE_USER_PROFILE_IN_CPM_ADGROUP,
                new NumberDefectParams().withMax(1));
    }

    public static Defect notFoundRetargeting() {
        return new Defect<>(RetargetingDefectIds.Gen.NOT_FOUND);
    }

    public static Defect warningNotSuspendedRetargeting() {
        return new Defect<>(RetargetingDefectIds.Gen.WARNING_NOT_SUSPENDED);
    }

    public static Defect warningAlreadySuspendedRetargeting() {
        return new Defect<>(RetargetingDefectIds.Gen.WARNING_ALREADY_SUSPENDED);
    }

    public static Defect warningDuplicatedRetargetingId() {
        return new Defect<>(RetargetingDefectIds.Gen.WARNING_DUPLICATED_RETARGETING_ID);
    }

    public static Defect audienceTargetNotFound() {
        return new Defect<>(RetargetingDefectIds.Gen.AUDIENCE_NOT_FOUND);
    }

    public static Defect duplicatedRetargetingConditionIdForAdgroupId() {
        return new Defect<>(RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID_FOR_ADGROUP_ID);
    }

    public static Defect retargetingConditionAlreadyExists() {
        return new Defect<>(RetargetingDefectIds.Gen.RETARGETING_CONDITION_ALREADY_EXISTS);
    }

    public static Defect retargetingConditionNotFoundDetailed() {
        return new Defect<>(RetargetingDefectIds.Gen.RETARGETING_CONDITION_NOT_FOUND);
    }

    public static Defect retargetingConditionNotFoundDetailed(long retargetingConditionId) {
        return new Defect<>(RetargetingDefectIds.IdParametrized.RETARGETING_CONDITION_NOT_FOUND_WITH_ID,
                new ModelIdDefectParams().withId(retargetingConditionId));
    }

    public static Defect retargetingConditionIsInvalidForRetargeting() {
        return new Defect<>(RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION);
    }

    public static Defect retargetingConditionIsInvalidForPricePackage() {
        return new Defect<>(RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_BY_PRICE_PACKAGE);
    }

    public static Defect retargetingConditionIsInvalidByDefaultAdGroup() {
        return new Defect<>(RetargetingDefectIds.Gen.INCONSISTENT_RETARGETING_CONDITION_BY_DEFAULT_ADGROUP);
    }

    public static Defect invalidRetargetingConditionInUserProfileInTgo() {
        return new Defect<>(RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_IN_USER_PROFILE_FOR_TGO);
    }

    public static Defect inconsistentStateTargetingCategoryUnavailable() {
        return new Defect<>(RetargetingDefectIds.Gen.INCONSISTENT_STATE_TARGETING_CATEGORY);
    }

    public static Defect notEligibleAdGroup() {
        return new Defect<>(RetargetingDefectIds.Gen.NOT_ELIGABLE_ADGROUP);
    }

    public static Defect allGoalsMustBeEitherFromMetrikaOrCrypta() {
        return new Defect<>(RetargetingDefectIds.Gen.ALL_GOALS_MUST_BE_EITHER_FROM_METRIKA_OR_CRYPTA);
    }

    public static Defect duplicatedGoal() {
        return new Defect<>(RetargetingDefectIds.Gen.DUPLICATED_GOAL);
    }

    public static Defect cryptaGoalsAllowedOnlyForInterestsType() {
        return new Defect<>(RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_INTERESTS_TYPE);
    }

    public static Defect cryptaGoalsAllowedOnlyForOrCondition() {
        return new Defect<>(RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_OR_CONDITION);
    }

    public static Defect interestsTypeIsNotSpecified() {
        return new Defect<>(RetargetingDefectIds.Gen.INTERESTS_TYPE_IS_NOT_SPECIFIED);
    }

    public static Defect allCryptaGoalsMustHaveSameType() {
        return new Defect<>(RetargetingDefectIds.Gen.ALL_CRYPTA_GOALS_MUST_HAVE_SAME_TYPE);
    }

    public static Defect mustHaveSameParentId() {
        return new Defect<>(RetargetingDefectIds.Gen.ALL_SOCIAL_DEMO_GOALS_MUST_HAVE_SAME_PARENT_ID);
    }

    public static Defect mustNotContainAllElements() {
        return new Defect<>(RetargetingDefectIds.Gen.MUST_NOT_CONTAIN_ALL_ELEMENTS);
    }

    public static Defect unsupportedGoalId() {
        return new Defect<>(RetargetingDefectIds.Gen.UNSUPPORTED_GOAL_ID);
    }

    public static Defect allElementsAreNegative() {
        return new Defect<>(RetargetingDefectIds.Gen.MUST_CONTAIN_POSITIVE_ELEMENT);
    }

    public static Defect interestLimitExceeded() {
        return new Defect<>(RetargetingDefectIds.Gen.INTEREST_LIMIT_EXCEEDED);
    }

    public static Defect adGroupNotFound(Long adGroupId) {
        return new Defect<>(RetargetingDefectIds.IdParametrized.ADGROUP_NOT_FOUND,
                new ModelIdDefectParams().withId(adGroupId));
    }

    public static Defect<BidsDefects.BidsParams> autobudgetPriorityNotMatchStrategy() {
        return BidsDefects.fieldDoesNotMatchStrategy(
                new BidsDefects.BidsParams().withField(SetBidItem.AUTOBUDGET_PRIORITY).withId(null));
    }

    public static Defect audienceTargetAllowedOnlyInMobileContentCampaign() {
        return new Defect<>(RetargetingDefectIds.Gen.AUDIENCE_TARGET_ALLOWED_IN_MOBILE_CONTENT_CAMPAIGN);
    }

    public static Defect cpmYndxFrontpageRetargetingsNotAllowed() {
        return new Defect<>(RetargetingDefectIds.Gen.CPM_YNDX_FRONTPAGE_RETARGETINGS_NOT_ALLOWED);
    }
}
