package ru.yandex.direct.core.entity.retargeting.service.validation2.constraint;

import java.util.Set;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;

public class GoalExistenceConstraint2 implements Constraint<Long, Defect> {

    private Set<Long> clientGoalIds;

    public GoalExistenceConstraint2(Set<Long> clientGoalIds) {
        this.clientGoalIds = clientGoalIds;
    }

    public static GoalExistenceConstraint2 goalExists(Set<Long> clientGoalIds) {
        return new GoalExistenceConstraint2(clientGoalIds);
    }

    @Override
    public Defect apply(Long goalId) {
        return goalId == null || clientGoalIds.contains(goalId) ?
                null :
                CommonDefects.objectNotFound();
    }
}
