package ru.yandex.direct.core.entity.retargeting.service.validation2.constraint;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.GoalType;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefects.requiredTimeForGoalOrSegment;

public class GoalTimeConsistencyConstraint2 implements Constraint<Goal, Defect> {

    private static final GoalTimeConsistencyConstraint2 CONSTRAINT = new GoalTimeConsistencyConstraint2();

    public static GoalTimeConsistencyConstraint2 goalTimeIsConsistent() {
        return CONSTRAINT;
    }

    @Override
    public Defect apply(Goal goal) {
        if (goal == null || goal.getType() == null) {
            return null;
        }

        if ((goal.getType() == GoalType.GOAL || goal.getType() == GoalType.ECOMMERCE)
                && (goal.getTime() == null)) {
            return requiredTimeForGoalOrSegment();
        }
        return null;
    }
}
