package ru.yandex.direct.core.entity.retargeting.service.validation2.constraint;

import java.util.Set;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefects.unsupportedGoalId;

public class OrphanFamilySegmentConstraint implements Constraint<Long, Defect> {

    private Set<Long> orphanFamilySegmentIds;

    public OrphanFamilySegmentConstraint(Set<Long> orphanFamilySegmentIds) {
        this.orphanFamilySegmentIds = orphanFamilySegmentIds;
    }

    public static OrphanFamilySegmentConstraint isNotAnOrphanFamilySegment(Set<Long> orphanFamilySegmentIds) {
        return new OrphanFamilySegmentConstraint(orphanFamilySegmentIds);
    }

    @Override
    public Defect apply(Long goalId) {
        return goalId == null || !orphanFamilySegmentIds.contains(goalId) ?
                null :
                unsupportedGoalId();
    }
}
