package ru.yandex.direct.core.entity.retargeting.service.validation2.cpmprice;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;

@ParametersAreNonnullByDefault
public class RetargetingConditionIdCpmPriceValidator extends RetargetingConditionsCpmPriceValidatorBase<Long> {

    private final Map<Long, RetargetingCondition> retargetingConditions;

    public RetargetingConditionIdCpmPriceValidator(
            RetargetingConditionsCpmPriceValidationData data,
            Map<Long, RetargetingCondition> retargetingConditions) {
        super(data);
        this.retargetingConditions = retargetingConditions;
    }

    @Override
    RetargetingCondition getRetargetingConditionForValidatingObject(Long retargetingConditionId) {
        return retargetingConditions.get(retargetingConditionId);
    }
}
