package ru.yandex.direct.core.entity.retargeting.service.validation2.cpmprice;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CpmPriceCampaign;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class RetargetingConditionsCpmPriceValidationData {

    private final Map<Long, CpmPriceCampaign> cpmPriceCampaigns;
    private final Map<Long, PricePackage> pricePackageByCampaignIds;
    //данные ретаргетингов дефолтной группы по id кампании
    private final Map<Long, RetargetingCondition> defaultAdGroupRetargetingConditionByCampaignIds;
    private final Map<Long, Long> adGroupsCpmPriceCampaignId;
    private final Map<Long, Long> adGroupsPriority;
    private final Map<Long, List<Long>> adGroupIdsByRetargetingConditionId;
    private final Map<Long, AdGroupType> adGroupsType;

    public RetargetingConditionsCpmPriceValidationData(
            Map<Long, CpmPriceCampaign> cpmPriceCampaigns,
            Map<Long, PricePackage> pricePackageByCampaignIds,
            Map<Long, RetargetingCondition> defaultAdGroupRetargetingConditionByCampaignIds,
            Map<Long, Long> adGroupsCpmPriceCampaignId,
            Map<Long, Long> adGroupsPriority,
            Map<Long, List<Long>> adGroupIdsByRetargetingConditionId,
            Map<Long, AdGroupType> adGroupsType
    ) {
        this.cpmPriceCampaigns = cpmPriceCampaigns;
        this.pricePackageByCampaignIds = pricePackageByCampaignIds;
        this.defaultAdGroupRetargetingConditionByCampaignIds = defaultAdGroupRetargetingConditionByCampaignIds;
        this.adGroupsCpmPriceCampaignId = adGroupsCpmPriceCampaignId;
        this.adGroupsPriority = adGroupsPriority;
        this.adGroupIdsByRetargetingConditionId = adGroupIdsByRetargetingConditionId;
        this.adGroupsType = adGroupsType;
    }

    CpmPriceCampaign getCpmPriceCampaignForAdGroup(Long adGroupId) {
        Long campaignId = adGroupsCpmPriceCampaignId.get(adGroupId);
        return ifNotNull(campaignId, cpmPriceCampaigns::get);
    }

    Long getAdGroupPriority(Long adGroupId) {
        return adGroupsPriority.get(adGroupId);
    }

    List<Long> getAdGroupIdsForRetargetingCondition(Long retargetingConditionId) {
        return adGroupIdsByRetargetingConditionId.getOrDefault(retargetingConditionId, emptyList());
    }

    AdGroupType getAdGroupType(Long adGroupId) {
        return adGroupsType.get(adGroupId);
    }

    public PricePackage getPricePackage(Long campaignId) {
        return pricePackageByCampaignIds.get(campaignId);
    }

    /**
     * данные ретаргетингов дефолтной группы по id кампании
     */
    public RetargetingCondition getDefaultAdGroupRetargetingCondition(Long campaignId) {
        return defaultAdGroupRetargetingConditionByCampaignIds.get(campaignId);
    }
}
