package ru.yandex.direct.core.entity.sessionvariables.repository;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.monitor.tables.StoredVars.STORED_VARS;

/**
 * Работа с сессиоными переменными
 */
@ParametersAreNonnullByDefault
@Repository
public class StoredVarsRepository {
    protected final DslContextProvider dslContextProvider;

    @Autowired
    public StoredVarsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Удаляет значения старше указанного времени из таблицы stored_vars
     *
     * @param borderDateTime {@link LocalDateTime} граничное время
     * @return число удаленных записей
     */
    public int deleteStoredVarsOlderThan(LocalDateTime borderDateTime) {
        return dslContextProvider.monitor()
                .deleteFrom(STORED_VARS)
                .where(STORED_VARS.LOGDATE.lessThan(borderDateTime))
                .execute();
    }

}
