package ru.yandex.direct.core.entity.showcondition.container;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.keyword.service.KeywordRecentStatisticsProvider;

/**
 * Контейнер с параметрами для автоматического выставления недостающих ставок
 * в условиях показов.
 * <p>
 * Не всем условиям показов могут понадобиться все параметры их этого
 * контейнера. Например, {@code keywordRecentStatisticsProvider} пока
 * используется только для вычисления автоматических ставок бесфразных
 * таргетингов.
 */
@ParametersAreNonnullByDefault
public class ShowConditionAutoPriceParams {
    private final ShowConditionFixedAutoPrices fixedAutoPrices;
    private final KeywordRecentStatisticsProvider keywordRecentStatisticsProvider;

    /**
     * @param fixedAutoPrices                 контейнер с фиксированными ставками
     * @param keywordRecentStatisticsProvider объект для получения недавней статистики по ключевым словам
     */
    public ShowConditionAutoPriceParams(
            ShowConditionFixedAutoPrices fixedAutoPrices,
            KeywordRecentStatisticsProvider keywordRecentStatisticsProvider) {
        this.fixedAutoPrices = fixedAutoPrices;
        this.keywordRecentStatisticsProvider = keywordRecentStatisticsProvider;
    }

    public ShowConditionFixedAutoPrices getFixedAutoPrices() {
        return fixedAutoPrices;
    }

    public KeywordRecentStatisticsProvider getKeywordRecentStatisticsProvider() {
        return keywordRecentStatisticsProvider;
    }
}
