package ru.yandex.direct.core.entity.showcondition.model;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.advq.Age;
import ru.yandex.direct.advq.Device;
import ru.yandex.direct.advq.Gender;
import ru.yandex.direct.advq.search.AdvqRequestKeyword;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class ShowStatRequest {

    private String geo;
    private List<String> commonMinusPhrases;
    private List<AdvqRequestKeyword> keywords;
    private Long campaignId;
    private Long adGroupId;
    private List<Long> libraryMinusPhrasesIds;
    private Set<Device> deviceTypes;
    private Gender gender;
    private Set<Age> ages;
    private boolean isContentPromotionVideo;
    private boolean needSearchedWith;
    private boolean needSearchedAlso;
    private Integer limit;

    public String getGeo() {
        return geo;
    }

    public ShowStatRequest withGeo(String geo) {
        this.geo = geo;
        return this;
    }

    public List<String> getCommonMinusPhrases() {
        return commonMinusPhrases;
    }

    public ShowStatRequest withCommonMinusPhrases(List<String> commonMinusPhrases) {
        this.commonMinusPhrases = commonMinusPhrases;
        return this;
    }

    public List<AdvqRequestKeyword> getKeywords() {
        return keywords;
    }

    public ShowStatRequest withPhrases(List<String> phrases) {
        this.keywords = mapList(phrases, AdvqRequestKeyword::new);
        return this;
    }

    public ShowStatRequest withKeywords(List<AdvqRequestKeyword> keywords) {
        this.keywords = keywords;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public ShowStatRequest withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public ShowStatRequest withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public List<Long> getLibraryMinusPhrasesIds() {
        return libraryMinusPhrasesIds;
    }

    public ShowStatRequest withLibraryMinusPhrasesIds(List<Long> libraryMinusPhrasesIds) {
        this.libraryMinusPhrasesIds = libraryMinusPhrasesIds;
        return this;
    }

    public Set<Device> getDeviceTypes() {
        return deviceTypes;
    }

    public ShowStatRequest withDeviceTypes(Set<Device> deviceTypes) {
        this.deviceTypes = deviceTypes;
        return this;
    }

    public Gender getGender() {
        return gender;
    }

    public ShowStatRequest withGender(Gender gender) {
        this.gender = gender;
        return this;
    }

    public Set<Age> getAges() {
        return ages;
    }

    public ShowStatRequest withAges(Set<Age> ages) {
        this.ages = ages;
        return this;
    }

    public boolean isContentPromotionVideo() {
        return isContentPromotionVideo;
    }

    public ShowStatRequest withIsContentPromotionVideo(boolean contentPromotionVideo) {
        isContentPromotionVideo = contentPromotionVideo;
        return this;
    }

    public boolean isNeedSearchedWith() {
        return needSearchedWith;
    }

    public ShowStatRequest withNeedSearchedWith(boolean needSearchedWith) {
        this.needSearchedWith = needSearchedWith;
        return this;
    }

    public boolean isNeedSearchedAlso() {
        return needSearchedAlso;
    }

    public ShowStatRequest withNeedSearchedAlso(boolean needSearchedAlso) {
        this.needSearchedAlso = needSearchedAlso;
        return this;
    }

    public Integer getLimit() {
        return limit;
    }

    public ShowStatRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }
}
