package ru.yandex.direct.core.entity.showcondition.service;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.advq.AdvqClient;
import ru.yandex.direct.advq.AdvqSearchOptions;
import ru.yandex.direct.advq.SearchKeywordResult;
import ru.yandex.direct.advq.SearchRequest;
import ru.yandex.direct.advq.search.AdvqRequestKeyword;
import ru.yandex.direct.advq.search.ParserType;
import ru.yandex.direct.core.entity.showcondition.model.ShowStatRequest;

import static com.google.common.base.Preconditions.checkState;
import static java.util.Collections.singletonList;

@Service
public class ShowStatService {

    private final AdvqClient advqClient;
    private final ShowStatConverter showStatConverter;

    @Autowired
    public ShowStatService(AdvqClient advqClient,
                           ShowStatConverter showStatConverter) {
        this.advqClient = advqClient;
        this.showStatConverter = showStatConverter;
    }

    public Map<AdvqRequestKeyword, SearchKeywordResult> getStatShowByPhrase(ShowStatRequest request) {
        SearchRequest searchRequest = showStatConverter.convertRequest(request);
        return getStatShowByPhrase(request, searchRequest);
    }

    public Map<AdvqRequestKeyword, SearchKeywordResult> getStatShowByPhrase(ShowStatRequest request,
                                                                            SearchRequest convertedRequest) {
        AdvqSearchOptions advqSearchOptions = getAdvqSearchOptions(request);

        Map<SearchRequest, Map<AdvqRequestKeyword, SearchKeywordResult>> advqResults;
        if (request.isContentPromotionVideo()) {
            advqResults = advqClient.searchVideo(singletonList(convertedRequest), advqSearchOptions);
        } else {
            advqResults = advqClient.search(singletonList(convertedRequest), advqSearchOptions);
        }

        return advqResults.get(convertedRequest);
    }

    private AdvqSearchOptions getAdvqSearchOptions(ShowStatRequest request) {
        AdvqSearchOptions advqSearchOptions = request.isNeedSearchedWith() ?
                getAdvqSearchOptions() : getAdvqSearchOptionsWithoutSearchedWith();

        if (!request.isNeedSearchedAlso()) {
            advqSearchOptions.withFastMode(true);
        }

        if (request.getLimit() != null) {
            checkState(request.isNeedSearchedWith(),
                    "inconsistent request: limit is specified, but field searchedWith is not needed");
            advqSearchOptions.withPhPageSize(request.getLimit());
        }

        return advqSearchOptions;
    }

    public static AdvqSearchOptions getAdvqSearchOptions() {
        return new AdvqSearchOptions()
                .withParserType(ParserType.DIRECT)
                .withAssocs(Boolean.TRUE)
                .withCalcTotalHits(Boolean.TRUE)
                .withPhPage(0)
                .withPhPageSize(2000);
    }

    public static AdvqSearchOptions getAdvqSearchOptionsWithoutSearchedWith() {
        return new AdvqSearchOptions()
                .withParserType(ParserType.DIRECT)
                .withAssocs(Boolean.FALSE)
                .withCalcTotalHits(Boolean.TRUE)
                .withPhPage(0)
                .withPhPageSize(0);
    }
}
