package ru.yandex.direct.core.entity.sitelink.repository.mapper;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.sitelink.turbolanding.model.SitelinkTurboLanding;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.core.entity.turbolanding.repository.mapper.TurboLandingMapperProvider.getCommonMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.SITELINKS_LINKS;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@ParametersAreNonnullByDefault
public class SitelinkTurboLandingMapperProvider {
    private static final JooqMapperWithSupplier<SitelinkTurboLanding> MAPPER = createMapper();

    private SitelinkTurboLandingMapperProvider() {
    }

    public static JooqMapperWithSupplier<SitelinkTurboLanding> getSitelinkTurboLandingMapper() {
        return MAPPER;
    }

    private static JooqMapperWithSupplier<SitelinkTurboLanding> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(getCommonMapper(), SitelinkTurboLanding::new)
                .writeField(SITELINKS_LINKS.TL_ID, fromProperty(SitelinkTurboLanding.ID))
                .build();
    }
}
