package ru.yandex.direct.core.entity.sitelink.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.sitelink.model.Sitelink;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class SitelinkUtils {

    public static Sitelink cloneSitelink(Sitelink sitelink) {
        return new Sitelink()
                .withId(sitelink.getId())
                .withTitle(sitelink.getTitle())
                .withHref(sitelink.getHref())
                .withDescription(sitelink.getDescription())
                .withOrderNum(sitelink.getOrderNum())
                .withHash(sitelink.getHash())
                .withTurboLandingId(sitelink.getTurboLandingId());
    }

    public static List<Sitelink> cloneSitelinks(List<Sitelink> sitelinks) {
        return mapList(sitelinks, SitelinkUtils::cloneSitelink);
    }
}
