package ru.yandex.direct.core.entity.sitelink.service.validation;

import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class SitelinkDefectIds {

    public enum Gen implements DefectId<Void> {
        DUPLICATE_SITELINK_TITLES,
        DUPLICATE_SITELINK_DESCS,

        MAX_ELEMENTS_PER_DELETE_REQUEST,
        OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST,
        /**
         * Не указан текст быстрой ссылки
         */
        SITELINK_TITLE_CANNOT_BE_EMPTY,
        /**
         * Не указан текст описания быстрой ссылки
         */
        SITELINK_DESCRIPTION_CANNOT_BE_EMPTY,
        /**
         * Неправильный формат быстрой ссылки
         */
        INVALID_SITELINK_HREF,
        /**
         * Указанна ссылка не на турбостраницу
         */
        REQUIRED_SITELINK_WITH_TURBO_HREF_OR_TURBOLANDING_ID
    }

    public enum Strings implements DefectId<StringDefectParams> {
        ALLOWED_SYMBOLS_SITELINK_TITLE,
        ALLOWED_SYMBOLS_SITELINK_DESC,

        MAX_SITELINKS_TITLES_LENGTH,
        /**
         * Превышена допустимая длина текстов блока сайтлинков с 1го по 4й
         */
        MAX_SITELINKS_FIRST_BLOCK_TITLES_LENGTH,
        /**
         * Превышена допустимая длина текстов блока сайтлинков с 5го по 8й
         */
        MAX_SITELINKS_SECOND_BLOCK_TITLES_LENGTH,
        /**
         * Превышена допустимая длина текста одного описания быстрой ссылки в x символов
         */
        SITELINK_DESCRIPTION_LENGTH_CANNOT_BE_MORE_THAN_MAX,
        /**
         * Превышена допустимая длина одной быстрой ссылки в x символов
         */
        SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
        /**
         * Превышена допустимая длина текста одной быстрой ссылки в x символов
         */
        SITELINK_TITLE_LENGTH_CANNOT_BE_MORE_THAN_MAX
    }

    public enum Nums implements DefectId<NumberDefectParams> {
    }
}
