package ru.yandex.direct.core.entity.sitelink.service.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.types.Identity;

public interface SitelinkDefectTranslations extends TranslationBundle {

    SitelinkDefectTranslations INSTANCE = I18NBundle.implement(SitelinkDefectTranslations.class);

    @MessageFormatStub("В тексте быстрых ссылок можно использовать только буквы латинского, турецкого, русского, " +
            "украинского, белорусского или казахского алфавита, знаки пунктуации, за исключением !,?")
    Translatable notAllowedSymbolsInSitelinkTitle();

    @MessageFormatStub("В описании быстрых ссылок можно использовать только буквы латинского, турецкого, русского, " +
            "украинского, белорусского или казахского алфавита, знаки пунктуации, за исключением !,?")
    Translatable notAllowedSymbolsInSitelinkDesc();

    @MessageFormatStub("Превышена суммарная длина текста быстрых ссылок")
    Translatable maxSitelinkTitlesSize();

    @MessageFormatStub("Превышена суммарная длина текста быстрых ссылок — максимум {0} символов")
    Translatable maxSitelinkTitlesSizeWithMax(Identity max);

    @MessageFormatStub("Суммарная длина текстов быстрых ссылок № 1-4 превышает {0} символов")
    Translatable maxSitelinkTitlesSizeWithMaxFirstBlock(Identity max);

    @MessageFormatStub("Суммарная длина текстов быстрых ссылок № 5-8 превышает {0} символов")
    Translatable maxSitelinkTitlesSizeWithMaxSecondBlock(Identity max);

    @MessageFormatStub("Тексты быстрых ссылок не должны быть одинаковыми")
    Translatable duplicateSitelinkTitles();

    @MessageFormatStub("Описания быстрых ссылок не должны быть одинаковыми")
    Translatable duplicateSitelinkDescs();

    @MessageFormatStub("Быстрые ссылки не должны вести на одну и ту же страницу сайта")
    Translatable duplicateSitelinkHrefs();

    @MessageFormatStub("Не указан текст быстрой ссылки")
    Translatable sitelinkTitleCannotBeEmpty();

    @MessageFormatStub("Не указан текст описания быстрой ссылки")
    Translatable sitelinkDescriptionCannotBeEmpty();

    @MessageFormatStub("Превышена допустимая длина текста одного описания быстрой ссылки в {0} символов")
    Translatable sitelinkDescriptionLengthCannotBeMoreThanMax(Identity max);

    @MessageFormatStub("Неправильный формат адреса быстрой ссылки: {0}")
    Translatable invalidSitelinkHref(String href);

    @MessageFormatStub("Превышена допустимая длина адреса одной быстрой ссылки в {0} символов")
    Translatable sitelinkHrefLengthCannotBeMoreThanMax(Identity max);

    @MessageFormatStub("Превышена допустимая длина текста одной быстрой ссылки в {0} символов")
    Translatable sitelinkTitleLengthCannotBeMoreThanMax(Identity max);

    @MessageFormatStub("Количество быстрых ссылок должно быть от {0} до {1}")
    Translatable sitelinkCountInInterval(Identity min, Identity max);

    @MessageFormatStub("Набор быстрых ссылок {0}")
    Translatable sitelinkSetIdDetailed(String id);

    @MessageFormatStub("Разрешено удалять не более {0} быстрых ссылок в одном запросе")
    Translatable deleteMaxIdsDetailed(Identity max);
}
