package ru.yandex.direct.core.entity.sitelink.service.validation;

import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class SitelinkDefects {

    public static Defect allowedSymbolsSitelinkTitle() {
        return new Defect<>(SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_TITLE);
    }

    public static Defect allowedSymbolsSitelinkDesc() {
        return new Defect<>(SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_DESC);
    }

    public static Defect maxSetSitelinkTitlesSize(int maxSize) {
        return new Defect<>(SitelinkDefectIds.Strings.MAX_SITELINKS_TITLES_LENGTH,
                new StringDefectParams().withMaxLength(maxSize));
    }

    public static Defect maxSitelinksFirstBlockTitlesLength(int maxSize) {
        return new Defect<>(SitelinkDefectIds.Strings.MAX_SITELINKS_FIRST_BLOCK_TITLES_LENGTH,
                new StringDefectParams().withMaxLength(maxSize));
    }

    public static Defect maxSitelinksSecondBlockTitlesLength(int maxSize) {
        return new Defect<>(SitelinkDefectIds.Strings.MAX_SITELINKS_SECOND_BLOCK_TITLES_LENGTH,
                new StringDefectParams().withMaxLength(maxSize));
    }

    public static Defect duplicateSitelinkTitles() {
        return new Defect<>(SitelinkDefectIds.Gen.DUPLICATE_SITELINK_TITLES);
    }

    public static Defect duplicateSitelinkDescs() {
        return new Defect<>(SitelinkDefectIds.Gen.DUPLICATE_SITELINK_DESCS);
    }

    public static Defect maxElementsPerDeleteRequest() {
        return new Defect<>(SitelinkDefectIds.Gen.MAX_ELEMENTS_PER_DELETE_REQUEST);
    }

    public static Defect duplicateObject() {
        return new Defect<>(SitelinkDefectIds.Gen.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST);
    }

    public static Defect duplicateSitelinkSetInDb() {
        return new Defect<>(SitelinkSetDefectIds.Gen.DUPLICATE_SITELINK_SET);
    }

    public static Defect sitelinksTitleEmpty() {
        return new Defect<>(SitelinkDefectIds.Gen.SITELINK_TITLE_CANNOT_BE_EMPTY);
    }

    public static Defect sitelinksDescriptionEmpty() {
        return new Defect<>(SitelinkDefectIds.Gen.SITELINK_DESCRIPTION_CANNOT_BE_EMPTY);
    }

    public static Defect<StringDefectParams> sitelinkDescriptionTooLong(int maxStringLength) {
        return new Defect<>(SitelinkDefectIds.Strings.SITELINK_DESCRIPTION_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxStringLength));
    }

    public static Defect<Void> invalidSitelinkHref() {
        return new Defect<>(SitelinkDefectIds.Gen.INVALID_SITELINK_HREF);
    }

    public static Defect<StringDefectParams> sitelinkHrefTooLong(int maxStringLength) {
        return new Defect<>(SitelinkDefectIds.Strings.SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxStringLength));
    }

    public static Defect<StringDefectParams> sitelinkTitleTooLong(int maxStringLength) {
        return new Defect<>(SitelinkDefectIds.Strings.SITELINK_TITLE_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxStringLength));
    }

    public static Defect<Void> requiredSitelinkWithTurboHrefOrTurbolandingId() {
        return new Defect<>(SitelinkDefectIds.Gen.REQUIRED_SITELINK_WITH_TURBO_HREF_OR_TURBOLANDING_ID);
    }

}
