package ru.yandex.direct.core.entity.sitelink.service.validation;

import java.util.Map;

import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefects.duplicateSitelinkSetInDb;
import static ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefects.sitelinkSetInUse;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

public class SitelinkSetConstraints {
    private SitelinkSetConstraints() {
    }

    public static Constraint<Long, Defect> sitelinkSetNotUsed(Map<Long, Boolean> existsSiteLinks) {
        return fromPredicate(
                slSetId -> existsSiteLinks.get(slSetId) == null || !existsSiteLinks.get(slSetId),
                sitelinkSetInUse());
    }

    public static Constraint<SitelinkSet, Defect> sitelinkSetDoesNotHaveId() {
        return fromPredicate(sls -> sls.getId() == null, duplicateSitelinkSetInDb());
    }

    /**
     * Проверка что набор сайтлинков содержит ссылки на турболендинг или идентификатор турбостраницы
     */
    public static boolean isSitelinksSetContainsOnlyTurbolandings(SitelinkSet sitelinkSet) {
        return sitelinkSet.getSitelinks().stream()
                .allMatch(SitelinkConstraints::sitelinkContainsTurbolandingOnly);
    }
}
