package ru.yandex.direct.core.entity.sitelink.service.validation;

import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class SitelinkSetDefects {

    public static Defect sitelinkSetInUse() {
        return new Defect<>(SitelinkSetDefectIds.Gen.SITELINKS_SET_USED_AND_CANT_BE_DELETED);
    }

    public static Defect<CollectionSizeDefectParams> sitelinkCountMustBeBetween(int min, int max) {
        return new Defect<>(SitelinkSetDefectIds.Collections.SITELINKS_COUNT_MUST_BE_BETWEEN,
                new CollectionSizeDefectParams().withMinSize(min).withMaxSize(max));
    }
}
