package ru.yandex.direct.core.entity.sspplatform.repository

import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.internalads.repository.InternalYaBsClusterChooser
import ru.yandex.direct.core.entity.sspplatform.container.SspInfo
import ru.yandex.direct.core.entity.sspplatform.ytmodels.generated.YtDbTables.SSPINFO
import ru.yandex.direct.core.entity.sspplatform.ytmodels.generated.YtSspInfoRow
import ru.yandex.direct.ytwrapper.client.YtExecutionUtil
import ru.yandex.direct.ytwrapper.client.YtProvider

@Repository
class SspInfoYtRepository(
    private val ytProvider: YtProvider,
    private val clusterChooser: InternalYaBsClusterChooser
) {
    /**
     * Получить все записи таблицы SSPInfo из yt-таблицы, экспортируемой из БК
     */
    fun getAll(): List<SspInfo> {
        val clustersByPriority = clusterChooser.availableClustersOrdered
        return YtExecutionUtil.executeWithFallback(
            clustersByPriority, ytProvider::getOperator
        ) { operator -> operator.readTableAndMap(SSPINFO, YtSspInfoRow(), ::convertFromYt) }
    }

    companion object {
        private fun convertFromYt(row: YtSspInfoRow): SspInfo {
            return SspInfo(row.title, row.sspid, row.optionsProduction)
        }
    }
}
