package ru.yandex.direct.core.entity.sspplatform.repository;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.InsertValuesStep2;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.sspplatform.container.SspInfo;
import ru.yandex.direct.dbschema.ppcdict.tables.records.SspPlatformsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppcdict.tables.SspPlatforms.SSP_PLATFORMS;


@ParametersAreNonnullByDefault
@Repository
public class SspPlatformsRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    public SspPlatformsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Добавить в таблицу ppcdict.ssp_platforms новые SSP-площадки.
     * Площадки, названия которых уже есть в таблице, обновляются
     */
    public void mergeSspPlatforms(List<SspInfo> sspInfoList) {
        InsertValuesStep2<SspPlatformsRecord, String, Long> step =
                dslContextProvider.ppcdict().insertInto(SSP_PLATFORMS, SSP_PLATFORMS.TITLE, SSP_PLATFORMS.SSP_ID);
        sspInfoList.forEach(it -> step.values(it.getTitle(), it.getSspId()));
        step.onDuplicateKeyUpdate()
                .set(SSP_PLATFORMS.SSP_ID, MySQLDSL.values(SSP_PLATFORMS.SSP_ID))
                .execute();
    }

    /**
     * Получить список названий всех используемых площадок
     */
    public List<String> getAllSspPlatforms() {
        return dslContextProvider.ppcdict().select(SSP_PLATFORMS.TITLE).from(SSP_PLATFORMS).fetch(SSP_PLATFORMS.TITLE);
    }

    /**
     * Получить маппинг из названия площадки SSP в SSPID
     */
    public Map<String, Long> getSspTitlesToIds() {
        return dslContextProvider.ppcdict()
                .select(SSP_PLATFORMS.TITLE, SSP_PLATFORMS.SSP_ID)
                .from(SSP_PLATFORMS)
                .fetchMap(r -> r.getValue(SSP_PLATFORMS.TITLE), r -> r.getValue(SSP_PLATFORMS.SSP_ID));
    }
}
