package ru.yandex.direct.core.entity.statistics.container;

import java.util.Objects;

import org.jooq.types.ULong;

/**
 * Хранит в себе пару ключей adGroupId и phraseId
 **/
public class AdGroupIdAndPhraseIdPair {
    private final long adGroupId;
    private final ULong phraseId;

    public AdGroupIdAndPhraseIdPair(long adGroupId, ULong phraseId) {
        this.adGroupId = adGroupId;
        this.phraseId = phraseId;
    }

    public long getAdGroupId() {
        return adGroupId;
    }

    public ULong getPhraseId() {
        return phraseId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdGroupIdAndPhraseIdPair that = (AdGroupIdAndPhraseIdPair) o;
        return adGroupId == that.adGroupId &&
                phraseId.equals(that.phraseId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(adGroupId, phraseId);
    }
}
