package ru.yandex.direct.core.entity.statistics.container;

import java.util.Objects;

import ru.yandex.direct.ytwrapper.model.YtCluster;

public class ClusterToFreshnessTimestamp {
    private final YtCluster cluster;
    private final long timestamp;

    public ClusterToFreshnessTimestamp(YtCluster cluster, long timestamp) {
        this.cluster = cluster;
        this.timestamp = timestamp;
    }

    public YtCluster getCluster() {
        return cluster;
    }

    public long getTimestamp() {
        return timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterToFreshnessTimestamp that = (ClusterToFreshnessTimestamp) o;
        return timestamp == that.timestamp &&
                cluster == that.cluster;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cluster, timestamp);
    }

    @Override
    public String toString() {
        return "ClusterToFreshnessTimestamp{" +
                "cluster=" + cluster +
                ", timestamp=" + timestamp +
                '}';
    }
}
