package ru.yandex.direct.core.entity.statistics.container;

import java.time.LocalDate;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OrderIdWithPeriod {
    private final Long orderId;
    private final LocalDate start;
    private final LocalDate finish;

    public OrderIdWithPeriod(Long orderId, LocalDate start, LocalDate finish) {
        this.orderId = orderId;
        this.start = start;
        this.finish = finish;
    }

    public Long getOrderId() {
        return orderId;
    }

    public LocalDate getStart() {
        return start;
    }

    public LocalDate getFinish() {
        return finish;
    }
}
