package ru.yandex.direct.core.entity.statistics.container;

import java.math.BigDecimal;
import java.util.Objects;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;

public class ProceededActiveOrder {
    private long cid;
    private CampaignType type;
    private long newShows;
    private long newClicks;
    private BigDecimal newSumSpent;
    private long units;
    private long newSumSpentUnits;
    private boolean isRollbacked = false;
    private boolean isFinished = false;
    private boolean isNewShows = false;
    private boolean isMoneyEnd = false;
    private boolean isUnarchived = false;

    public ProceededActiveOrder(long cid, CampaignType type, long newShows, long newClicks,
                                BigDecimal newSumSpent, long units, long newSumSpentUnits) {
        this.cid = cid;
        this.type = type;
        this.newShows = newShows;
        this.newClicks = newClicks;
        this.newSumSpent = newSumSpent;
        this.units = units;
        this.newSumSpentUnits = newSumSpentUnits;
    }

    public long getCid() {
        return cid;
    }

    public CampaignType getType() {
        return type;
    }

    public long getNewShows() {
        return newShows;
    }

    public long getNewClicks() {
        return newClicks;
    }

    public BigDecimal getNewSumSpent() {
        return newSumSpent;
    }

    public long getUnits() {
        return units;
    }

    public long getNewSumSpentUnits() {
        return newSumSpentUnits;
    }

    public boolean isRollbacked() {
        return isRollbacked;
    }

    public boolean isFinished() {
        return isFinished;
    }

    public boolean isNewShows() {
        return isNewShows;
    }

    public boolean isMoneyEnd() {
        return isMoneyEnd;
    }

    public boolean isUnarchived() {
        return isUnarchived;
    }

    public void setRollbacked(boolean rollbacked) {
        isRollbacked = rollbacked;
    }

    public void setFinished(boolean finished) {
        isFinished = finished;
    }

    public void setNewShows(boolean newShows) {
        isNewShows = newShows;
    }

    public void setMoneyEnd(boolean moneyEnd) {
        isMoneyEnd = moneyEnd;
    }

    public void setUnarchived(boolean unarchived) {
        isUnarchived = unarchived;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProceededActiveOrder that = (ProceededActiveOrder) o;
        return cid == that.cid &&
                type == that.type &&
                newShows == that.newShows &&
                newClicks == that.newClicks &&
                units == that.units &&
                newSumSpentUnits == that.newSumSpentUnits &&
                isRollbacked == that.isRollbacked &&
                isFinished == that.isFinished &&
                isNewShows == that.isNewShows &&
                isMoneyEnd == that.isMoneyEnd &&
                isUnarchived == that.isUnarchived &&
                Objects.equals(newSumSpent, that.newSumSpent);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cid, type, newShows, newClicks, newSumSpent, units, newSumSpentUnits,
                isRollbacked, isFinished, isNewShows, isMoneyEnd, isUnarchived);
    }

    @Override
    public String toString() {
        return "ProceededActiveOrder{" +
                "cid=" + cid +
                ", type=" + type +
                ", newShows=" + newShows +
                ", newClicks=" + newClicks +
                ", newSumSpent=" + newSumSpent +
                ", units=" + units +
                ", newSumSpentUnits=" + newSumSpentUnits +
                ", isRollbacked=" + isRollbacked +
                ", isFinished=" + isFinished +
                ", isNewShows=" + isNewShows +
                ", isMoneyEnd=" + isMoneyEnd +
                ", isUnarchived=" + isUnarchived +
                '}';
    }
}
