package ru.yandex.direct.core.entity.statistics.container;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Objects;

public class ProcessedAuctionStat {
    private final Long pid;
    private final BigInteger phraseId;
    private final LocalDateTime statTime;
    private final Long clicks;
    private final Long pclicks;
    private final Long shows;
    private final Long pshows;
    private final Long rank;

    private ProcessedAuctionStat(Long pid, BigInteger phraseId, LocalDateTime statTime,
                                 Long clicks, Long pclicks, Long shows,
                                 Long pshows, Long rank) {
        this.pid = pid;
        this.phraseId = phraseId;
        this.statTime = statTime;
        this.clicks = clicks;
        this.pclicks = pclicks;
        this.shows = shows;
        this.pshows = pshows;
        this.rank = rank;
    }

    public Long getPid() {
        return pid;
    }

    public BigInteger getPhraseId() {
        return phraseId;
    }

    public LocalDateTime getStatTime() {
        return statTime;
    }

    public Long getClicks() {
        return clicks;
    }

    public Long getPclicks() {
        return pclicks;
    }

    public Long getShows() {
        return shows;
    }

    public Long getPshows() {
        return pshows;
    }

    public Long getRank() {
        return rank;
    }

    public static class Builder {
        private Long pid;
        private BigInteger phraseId;
        private LocalDateTime statTime;
        private Long clicks;
        private Long pclicks;
        private Long shows;
        private Long pshows;
        private Long rank;

        public Builder withPid(Long pid) {
            this.pid = pid;
            return this;
        }

        public Builder withPhraseId(BigInteger phraseId) {
            this.phraseId = phraseId;
            return this;
        }

        public Builder withStatTime(LocalDateTime statTime) {
            this.statTime = statTime;
            return this;
        }

        public Builder withClicks(Long clicks) {
            this.clicks = clicks;
            return this;
        }

        public Builder withPclicks(Long pclicks) {
            this.pclicks = pclicks;
            return this;
        }

        public Builder withShows(Long shows) {
            this.shows = shows;
            return this;
        }

        public Builder withPshows(Long pshows) {
            this.pshows = pshows;
            return this;
        }

        public Builder withRank(Long rank) {
            this.rank = rank;
            return this;
        }

        public ProcessedAuctionStat build() {
            return new ProcessedAuctionStat(pid, phraseId, statTime, clicks, pclicks, shows, pshows, rank);
        }
    }

    @Override
    public String toString() {
        return "ProcessedAuctionStat{" +
                "pid=" + pid +
                ", phraseId=" + phraseId +
                ", statTime=" + statTime +
                ", clicks=" + clicks +
                ", pclicks=" + pclicks +
                ", shows=" + shows +
                ", pshows=" + pshows +
                ", rank=" + rank +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProcessedAuctionStat that = (ProcessedAuctionStat) o;
        return Objects.equals(pid, that.pid) &&
                Objects.equals(phraseId, that.phraseId) &&
                Objects.equals(statTime, that.statTime) &&
                Objects.equals(clicks, that.clicks) &&
                Objects.equals(pclicks, that.pclicks) &&
                Objects.equals(shows, that.shows) &&
                Objects.equals(pshows, that.pshows) &&
                Objects.equals(rank, that.rank);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pid, phraseId, statTime, clicks, pclicks, shows, pshows, rank);
    }
}
