package ru.yandex.direct.core.entity.statistics.model;

import java.util.Objects;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;

public class ActiveOrderChanges {
    private final long orderId;
    private final long cid;
    private final int shard;
    private final CampaignType type;
    private final long oldShows;
    private final long oldSumSpent;
    private final long oldSumSpentUnits;
    private final long sum;
    private final long units;
    private final long walletCid;
    private final String archived;
    private final long newShows;
    private final long newClicks;
    private final long newSumSpent;
    private final long newSumSpentUnits;
    private final long cost;
    private final long costCur;
    private final long updateTime;

    private ActiveOrderChanges(long orderId, long cid, int shard, CampaignType type,
                               long oldShows, long oldSumSpent, long oldSumSpentUnits,
                               long sum, long units, long walletCid, String archived,
                               long newShows, long newClicks, long newSumSpent, long newSumSpentUnits,
                               long cost, long costCur, long updateTime) {
        this.orderId = orderId;
        this.cid = cid;
        this.shard = shard;
        this.type = type;
        this.oldShows = oldShows;
        this.oldSumSpent = oldSumSpent;
        this.oldSumSpentUnits = oldSumSpentUnits;
        this.sum = sum;
        this.units = units;
        this.walletCid = walletCid;
        this.archived = archived;
        this.newShows = newShows;
        this.newClicks = newClicks;
        this.newSumSpent = newSumSpent;
        this.newSumSpentUnits = newSumSpentUnits;
        this.cost = cost;
        this.costCur = costCur;
        this.updateTime = updateTime;
    }

    public long getOrderId() {
        return orderId;
    }

    public long getCid() {
        return cid;
    }

    public int getShard() {
        return shard;
    }

    public CampaignType getType() {
        return type;
    }

    public long getOldShows() {
        return oldShows;
    }

    public long getOldSumSpent() {
        return oldSumSpent;
    }

    public long getOldSumSpentUnits() {
        return oldSumSpentUnits;
    }

    public long getSum() {
        return sum;
    }

    public long getUnits() {
        return units;
    }

    public long getWalletCid() {
        return walletCid;
    }

    public String getArchived() {
        return archived;
    }

    public long getNewShows() {
        return newShows;
    }

    public long getNewClicks() {
        return newClicks;
    }

    public long getNewSumSpent() {
        return newSumSpent;
    }

    public long getNewSumSpentUnits() {
        return newSumSpentUnits;
    }

    public long getCost() {
        return cost;
    }

    public long getCostCur() {
        return costCur;
    }

    public long getUpdateTime() {
        return updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActiveOrderChanges that = (ActiveOrderChanges) o;
        return orderId == that.orderId &&
                cid == that.cid &&
                shard == that.shard &&
                type == that.type &&
                oldShows == that.oldShows &&
                oldSumSpent == that.oldSumSpent &&
                oldSumSpentUnits == that.oldSumSpentUnits &&
                sum == that.sum &&
                units == that.units &&
                walletCid == that.walletCid &&
                newShows == that.newShows &&
                newClicks == that.newClicks &&
                newSumSpent == that.newSumSpent &&
                newSumSpentUnits == that.newSumSpentUnits &&
                cost == that.cost &&
                costCur == that.costCur &&
                updateTime == that.updateTime &&
                Objects.equals(archived, that.archived);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderId, cid, shard, type, oldShows, oldSumSpent, oldSumSpentUnits, sum, units, walletCid,
                archived, newShows, newClicks, newSumSpent, newSumSpentUnits, cost, costCur, updateTime);
    }

    public static class Builder {
        private long orderId;
        private long cid;
        private int shard;
        private CampaignType type;
        private long oldShows;
        private long oldSumSpent;
        private long oldSumSpentUnits;
        private long sum;
        private long units;
        private long walletCid;
        private String archived;
        private long newShows;
        private long newClicks;
        private long newSumSpent;
        private long newSumSpentUnits;
        private long cost;
        private long costCur;
        private long updateTime;

        public Builder withOrderId(long orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder withCid(long cid) {
            this.cid = cid;
            return this;
        }

        public Builder withShard(int shard) {
            this.shard = shard;
            return this;
        }

        public Builder withType(CampaignType type) {
            this.type = type;
            return this;
        }

        public Builder withOldShows(long oldShows) {
            this.oldShows = oldShows;
            return this;
        }

        public Builder withOldSumSpent(long oldSumSpent) {
            this.oldSumSpent = oldSumSpent;
            return this;
        }

        public Builder withOldSumSpentUnits(long oldSumSpentUnits) {
            this.oldSumSpentUnits = oldSumSpentUnits;
            return this;
        }

        public Builder withSum(long sum) {
            this.sum = sum;
            return this;
        }

        public Builder withUnits(long units) {
            this.units = units;
            return this;
        }

        public Builder withWalletCid(long walletCid) {
            this.walletCid = walletCid;
            return this;
        }

        public Builder withNewShows(long newShows) {
            this.newShows = newShows;
            return this;
        }

        public Builder withArchived(String archived) {
            this.archived = archived;
            return this;
        }

        public Builder withNewClicks(long newClicks) {
            this.newClicks = newClicks;
            return this;
        }

        public Builder withNewSumSpent(long newSumSpent) {
            this.newSumSpent = newSumSpent;
            return this;
        }

        public Builder withNewSumSpentUnits(long newSumSpentUnits) {
            this.newSumSpentUnits = newSumSpentUnits;
            return this;
        }

        public Builder withCost(long cost) {
            this.cost = cost;
            return this;
        }

        public Builder withCostCur(long costCur) {
            this.costCur = costCur;
            return this;
        }

        public Builder withUpdateTime(long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ActiveOrderChanges build() {
            return new ActiveOrderChanges(orderId, cid, shard, type, oldShows, oldSumSpent, oldSumSpentUnits,
                    sum, units, walletCid, archived, newShows, newClicks, newSumSpent, newSumSpentUnits,
                    cost, costCur, updateTime);
        }
    }
}
