package ru.yandex.direct.core.entity.statistics.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class FraudAndGiftClicks {

    public static final FraudAndGiftClicks ZERO = new FraudAndGiftClicks(0L, 0L, 0L, 0L);

    @JsonProperty("fraudClicks")
    private final Long fraudClicks;

    @JsonProperty("giftClicks")
    private final Long giftClicks;

    @JsonProperty("fraudShowsGeneral")
    private final Long fraudShowsGeneral;

    @JsonProperty("fraudShowsSophisticated")
    private final Long fraudShowsSophisticated;

    public FraudAndGiftClicks(Long fraudClicks, Long giftClicks, Long fraudShowsGeneral, Long fraudShowsSophisticated) {
        this.fraudClicks = fraudClicks;
        this.giftClicks = giftClicks;
        this.fraudShowsGeneral = fraudShowsGeneral;
        this.fraudShowsSophisticated = fraudShowsSophisticated;
    }

    public Long getFraudClicks() {
        return fraudClicks;
    }

    public Long getGiftClicks() {
        return giftClicks;
    }

    public Long getFraudShowsGeneral() {
        return fraudShowsGeneral;
    }

    public Long getFraudShowsSophisticated() {
        return fraudShowsSophisticated;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FraudAndGiftClicks that = (FraudAndGiftClicks) o;
        return Objects.equals(fraudClicks, that.fraudClicks) &&
                Objects.equals(giftClicks, that.giftClicks) &&
                Objects.equals(fraudShowsGeneral, that.fraudShowsGeneral) &&
                Objects.equals(fraudShowsSophisticated, that.fraudShowsSophisticated);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fraudClicks, giftClicks, fraudShowsGeneral, fraudShowsSophisticated);
    }

    @Override
    public String toString() {
        return "FraudAndGiftClicks{" +
                "fraudClicks=" + fraudClicks +
                ", giftClicks=" + giftClicks +
                ", fraudShowsGeneral=" + fraudShowsGeneral +
                ", fraudShowsSophisticated=" + fraudShowsSophisticated +
                '}';
    }

    public static FraudAndGiftClicks sum(FraudAndGiftClicks p1, FraudAndGiftClicks p2) {
        return new FraudAndGiftClicks(
                p1.getFraudClicks() + p2.getFraudClicks(),
                p1.getGiftClicks() + p2.getGiftClicks(),
                p1.getFraudShowsGeneral() + p2.getFraudShowsGeneral(),
                p1.getFraudShowsSophisticated() + p2.getFraudShowsSophisticated()
        );
    }
}
