package ru.yandex.direct.core.entity.statistics.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Period {

    public static final String KEY_FIELD = "key";
    public static final String START_DATE_FIELD  = "startDate";
    public static final String END_DATE_FIELD  = "endDate";

    private final String key;
    private final LocalDate startDate;
    private final LocalDate endDate;

    @JsonCreator
    public Period(@JsonProperty(KEY_FIELD) String key,
                  @JsonProperty(START_DATE_FIELD) LocalDate startDate,
                  @JsonProperty(END_DATE_FIELD) LocalDate endDate) {
        this.key = key;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String getKey() {
        return key;
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public LocalDate getEndDate() {
        return endDate;
    }

    public boolean isDateInPeriod(LocalDate date) {
        return !date.isBefore(startDate) && !date.isAfter(endDate);
    }
}
