package ru.yandex.direct.core.entity.statistics.model;

import java.time.Instant;
import java.util.Objects;

public class SpentInfo {

    private final Long orderId;
    private final Instant statDate;
    private final Long cost;
    private final Long taxId;
    private final Long currencyId;

    public SpentInfo(Long orderId, Instant statDate, Long cost, Long taxId, Long currencyId) {
        this.orderId = orderId;
        this.statDate = statDate;
        this.cost = cost;
        this.taxId = taxId;
        this.currencyId = currencyId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public Instant getStatDate() {
        return statDate;
    }

    public Long getCost() {
        return cost;
    }

    public Long getTaxId() {
        return taxId;
    }

    public Long getCurrencyId() {
        return currencyId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SpentInfo spentInfo = (SpentInfo) o;
        return Objects.equals(orderId, spentInfo.orderId) &&
                Objects.equals(statDate, spentInfo.statDate) &&
                Objects.equals(cost, spentInfo.cost) &&
                Objects.equals(taxId, spentInfo.taxId) &&
                Objects.equals(currencyId, spentInfo.currencyId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orderId, statDate, cost, taxId, currencyId);
    }
}
