package ru.yandex.direct.core.entity.statistics.model;

import java.time.LocalDate;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class StatisticsDateRange {
    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private final LocalDate firstDate;

    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private final LocalDate lastDate;

    public StatisticsDateRange(LocalDate minUpdateDate, LocalDate maxUpdateDate) {
        this.firstDate = minUpdateDate;
        this.lastDate = maxUpdateDate;
    }

    public LocalDate getLastDate() {
        return lastDate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StatisticsDateRange that = (StatisticsDateRange) o;
        return Objects.equals(firstDate, that.firstDate) &&
                Objects.equals(lastDate, that.lastDate);
    }

    @Override
    public int hashCode() {

        return Objects.hash(firstDate, lastDate);
    }
}
