package ru.yandex.direct.core.entity.statistics.repository;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.statistics.model.StatisticsDateRange;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;

public class OrderStatDaySandboxRepository extends OrderStatDayRepository {
    private CampaignRepository campaignRepository;
    private ShardHelper shardHelper;

    // TODO: ppalex — вынести в интерфейс и отказаться от инициализации суперкласса
    public OrderStatDaySandboxRepository(ShardHelper shardHelper,
                                         CampaignRepository campaignRepository) {
        super(null);
        this.shardHelper = shardHelper;
        this.campaignRepository = campaignRepository;
    }

    /**
     * Возвращает словарь OrderID -> первые и последние даты существования кампаний
     * @param orderIds — коллекция заказов
     * @return словарь из номера заказа в первую и последнюю дату работы (существования, т. к. песочница) кампаний
     */
    @Override
    public Map<Long, StatisticsDateRange> getOrdersFirstLastDay(Collection<Long> orderIds) {
        if (orderIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, StatisticsDateRange> result = new HashMap<>();
        LocalDate maxDate = LocalDate.now();
        Map<Integer, List<Long>> shardedDataMap =
                shardHelper.groupByShard(orderIds, ShardKey.ORDER_ID).getShardedDataMap();
        for (Map.Entry<Integer, List<Long>> entry : shardedDataMap.entrySet()) {
            Map<Long, LocalDate> startDatesByOrderIds = campaignRepository.getCreateDatesByOrderIds(entry.getKey(),
                    entry.getValue());
            for (Map.Entry<Long, LocalDate> innerEntry : startDatesByOrderIds.entrySet()) {
                result.put(innerEntry.getKey(), new StatisticsDateRange(innerEntry.getValue(), maxDate));
            }
        }
        return result;
    }
}



