package ru.yandex.direct.core.entity.strategy.container

import ru.yandex.direct.core.entity.campaign.model.Campaign
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.service.RequestBasedMetrikaClientAdapter
import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.CpmYndxFrontpageAdGroupPriceRestrictions
import ru.yandex.direct.core.entity.retargeting.model.Goal
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.feature.FeatureName
import ru.yandex.direct.rbac.RbacRole
import java.time.LocalDateTime

/**
 * Некоторое обобщение контейнеров операций мутаций: Update и Add.
 * */
abstract class AbstractStrategyOperationContainer(
    open val shard: Int,
    open val clientId: ClientId,
    open val clientUid: Long,
    open val operator: Long,
    open val options: StrategyOperationOptions
) {

    open lateinit var currency: Currency

    var operatorRole: RbacRole? = null

    var cpmYndxFrontpageAdGroupPriceRestrictions: CpmYndxFrontpageAdGroupPriceRestrictions? = null

    val now: LocalDateTime = LocalDateTime.now()

    var wallet: Campaign? = null

    var availableFeatures: Set<FeatureName> = setOf()

    var metrikaClientAdapter: RequestBasedMetrikaClientAdapter? = null

    abstract fun campaignType(index: BaseStrategy): CampaignType?

    abstract fun campaigns(index: BaseStrategy): List<CampaignWithPackageStrategy>

    abstract fun strategyGoals(index: BaseStrategy): Set<Goal>
}
