package ru.yandex.direct.core.entity.strategy.container

import com.google.common.base.Preconditions.checkState
import java.util.IdentityHashMap
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCampaignType
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.retargeting.model.Goal
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.dbutil.model.ClientId

class StrategyAddOperationContainer(
    override val shard: Int,
    override val clientId: ClientId,
    override val clientUid: Long,
    override val operator: Long,
    override val options: StrategyOperationOptions = StrategyOperationOptions()
) : AbstractStrategyOperationContainer(shard, clientId, clientUid, operator, options) {

    override fun campaignType(index: BaseStrategy): CampaignType? =
        campaignTypesMap[index]

    override fun campaigns(index: BaseStrategy): List<CampaignWithPackageStrategy> =
        typedCampaignsMap[index] ?: emptyList()

    override fun strategyGoals(index: BaseStrategy): Set<Goal> =
        strategyGoalsMap[index] ?: emptySet()

    var campaignTypesMap: IdentityHashMap<BaseStrategy, CampaignType?> = IdentityHashMap()

    var typedCampaignsMap: IdentityHashMap<BaseStrategy, List<CampaignWithPackageStrategy>> = IdentityHashMap()
        set(value) {
            field = value
                .map {
                    it.key to it.value
                        .filter { campaign -> clientId.asLong() == campaign.clientId }
                        .toList()
                }
                .toMap(IdentityHashMap())

            campaignTypesMap = field.mapValues { getCampaignType(it.value) }.toMap(IdentityHashMap())
        }

    var strategyToIndexMap: IdentityHashMap<BaseStrategy, Int>? = null
        set(strategyToIndexMap) {
            checkState(this.strategyToIndexMap == null, "strategyToIndexMap is already set")
            field = strategyToIndexMap
        }

    var strategyGoalsMap: IdentityHashMap<BaseStrategy, Set<Goal>> = IdentityHashMap()

    var clientStrategiesNumber: Int = 0
    var clientUnarchivedStrategiesNumber: Int = 0

    companion object {
        fun getCampaignType(campaigns: List<CampaignWithCampaignType>): CampaignType? {
            val types = campaigns
                .map { it.type }
                .distinct()
            return types.firstOrNull()
        }
    }
}
