package ru.yandex.direct.core.entity.strategy.container

import org.jooq.DSLContext
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.autobudget.repository.AutobudgetCpaAlertRepository
import ru.yandex.direct.core.entity.autobudget.repository.AutobudgetHourlyAlertRepository
import ru.yandex.direct.core.entity.mailnotification.service.MailNotificationEventService

@Service
class StrategyAdditionalActionsService(private val autobudgetCpaAlertRepository: AutobudgetCpaAlertRepository,
                                       private val autobudgetHourlyAlertRepository: AutobudgetHourlyAlertRepository,
                                       private val mailNotificationEventService: MailNotificationEventService) {

    fun processAdditionalActionsContainer(dslContext: DSLContext,
                                          container: StrategyAdditionalActionsContainer,
                                          operationContainer: AbstractStrategyOperationContainer) {
        if (container.mailEvents.isNotEmpty()) {
            mailNotificationEventService.queueEvents(dslContext, operationContainer.operator, container.mailEvents)
        }
    }
}
