package ru.yandex.direct.core.entity.strategy.container

import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.retargeting.model.Goal
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer
import java.util.IdentityHashMap

class StrategyUpdateOperationContainer(
    override val shard: Int,
    override val clientId: ClientId,
    override val clientUid: Long,
    override val operator: Long,
    override val options: StrategyOperationOptions = StrategyOperationOptions()
) :
    UpdateOperationContainer<BaseStrategy>,
    AbstractStrategyOperationContainer(shard, clientId, clientUid, operator, options) {

    var strategyIdToClass: Map<Long, Class<out BaseStrategy>?> = emptyMap()

    override fun getRuntimeClass(modelId: Long): Class<out BaseStrategy> =
        strategyIdToClass[modelId]!!

    var campaignTypesMap: Map<Long, CampaignType?> = emptyMap()

    var typedCampaignsMap: Map<Long, List<CampaignWithPackageStrategy>> = emptyMap()
        set(value) {
            field = value
                .map {
                    it.key to it.value
                        .filter { campaign -> clientId.asLong() == campaign.clientId }
                        .toList()
                }
                .toMap()

            campaignTypesMap =
                value.mapValues { StrategyAddOperationContainer.getCampaignType(it.value) }
                    .toMap(IdentityHashMap())

        }

    var strategyGoalsMap: Map<Long, Set<Goal>> = emptyMap()

    var clientStrategiesNumber: Int = 0
    var clientUnarchivedStrategiesNumber: Int = 0

    fun campaignTypeById(modelId: Long): CampaignType? = campaignTypesMap[modelId]

    fun campaignsById(modelId: Long): List<CampaignWithPackageStrategy>? = typedCampaignsMap[modelId]

    //ожидаем что id модели в операции update определен всегда!!
    override fun campaignType(index: BaseStrategy): CampaignType? = campaignTypeById(index.id)

    override fun campaigns(index: BaseStrategy): List<CampaignWithPackageStrategy> = typedCampaignsMap[index.id] ?: emptyList()

    override fun strategyGoals(index: BaseStrategy): Set<Goal> = strategyGoalsMap[index.id] ?: emptySet()

    fun getStrategyIds() = strategyIdToClass.keys
}
