package ru.yandex.direct.core.entity.strategy.container

import javax.annotation.ParametersAreNonnullByDefault;
import ru.yandex.direct.feature.FeatureName

@ParametersAreNonnullByDefault
object StrategyUpdateOperationUtils {
    fun shouldFetchUnavailableGoals(container: AbstractStrategyOperationContainer) =
        container.availableFeatures.contains(FeatureName.DIRECT_UNAVAILABLE_AUTO_GOALS_ALLOWED) ||
            container.availableFeatures.contains(FeatureName.DIRECT_UNAVAILABLE_AUTO_GOALS_ALLOWED) ||
            container.availableFeatures.contains(FeatureName.UAC_UNAVAILABLE_AUTO_GOALS_ALLOWED) ||
            container.availableFeatures.contains(FeatureName.UAC_UNAVAILABLE_GOALS_ALLOWED)

}
