package ru.yandex.direct.core.entity.strategy.repository;

import java.util.Collection;

import org.jooq.Field;
import org.jooq.Record;

import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

public abstract class BaseStrategyDataFieldRepositoryTypeSupport<T extends BaseStrategy> extends AbstractStrategyRepositoryTypeSupport<T> {

    private final JooqMapper<T> mapper = createMapper();

    protected BaseStrategyDataFieldRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    protected JooqMapperBuilder<T> baseBuilder() {
        return JooqMapperBuilder.<T>builder()
                .map(property(T.ID, STRATEGIES.STRATEGY_ID));
    }

    @Override
    public Collection<Field<?>> getFields() {
        return mapper.getFieldsToRead();
    }

    @Override
    public <M extends T> void fillFromRecord(M model, Record record) {
        mapper.fromDb(record, model);
    }
}
