package ru.yandex.direct.core.entity.strategy.repository;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.jooq.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.strategy.container.StrategyRepositoryContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy;
import ru.yandex.direct.core.entity.strategy.model.StrategyName;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.multitype.repository.RepositoryTypeSupportFacade;
import ru.yandex.direct.multitype.repository.TypedRepository;
import ru.yandex.direct.multitype.repository.filter.Filter;

import static ru.yandex.direct.core.entity.strategy.repository.StrategyFilterFactory.strategyIdFilter;
import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;

@Repository
@ParametersAreNonnullByDefault
public class StrategyTypedRepository extends TypedRepository<BaseStrategy, StrategyName,
        StrategyRepositoryContainer, StrategyRepositoryContainer> {

    @Autowired
    public StrategyTypedRepository(DslContextProvider dslContextProvider, RepositoryTypeSupportFacade<BaseStrategy,
            StrategyName, StrategyRepositoryContainer, StrategyRepositoryContainer> typeSupportFacade) {
        super(dslContextProvider, typeSupportFacade);
    }

    @Override
    protected Filter getIdFilter(Collection<Long> modelIds) {
        return strategyIdFilter(modelIds);
    }

    @Override
    protected Table<?> getBaseTable() {
        return STRATEGIES;
    }

    public Map<Long, BaseStrategy> getIdToModelTyped(int shard, ClientId clientId, Collection<Long> modelIds) {
        return EntryStream.of(getIdToModelTyped(shard, modelIds))
                .filterValues(s -> ((CommonStrategy) s).getClientId().equals(clientId.asLong()))
                .toMap();
    }
}
