package ru.yandex.direct.core.entity.strategy.service

import org.springframework.stereotype.Service
import ru.yandex.direct.autobudget.restart.model.PackageStrategyRestartResult
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.repository.StrategyTypedRepository

@Service
class PackageStrategyAutobudgetRestartService(
    private val publicPackageStrategyAutobudgetRestartService: PublicPackageStrategyAutobudgetRestartService,
    private val privatePackageStrategyAutobudgetRestartService: PrivatePackageStrategyAutobudgetRestartService,
    private val strategyTypedRepository: StrategyTypedRepository
) {
    fun recalculateAndSaveRestarts(shard: Int, strategyIds: Set<Long>): List<PackageStrategyRestartResult> {
        val (publicStrategies, privateStrategies) = strategyTypedRepository.getTyped(shard, strategyIds)
            .mapNotNull { it as? CommonStrategy }
            .partition { it.isPublic }
        return publicPackageStrategyAutobudgetRestartService.recalculateAndSaveRestarts(shard, publicStrategies) +
            privatePackageStrategyAutobudgetRestartService.recalculateAndSaveRestarts(shard, privateStrategies)
    }
}
